// 1/10/2018
//
// Genus 0

load "FiberProductsData.m";


Genus0_P1:= [];
Genus0_PointlessConic:= [];


print "=== Genus 0 (Data) === ";
for k in CurvesByGenus[0] do
	C:=FiberProducts[k]`curve;
 	Pts := Points(C:Bound:=10^2);
	if not (#Pts eq 0) then 
		printf "%o --- P^1(Q)\n",k;	
		Append(~Genus0_P1,k);	
	  else
		printf "%o --- Pointless conic?\n",k;
		Append(~Genus0_PointlessConic,k);
	end if;
end for;


/////////////////////////////////////////////////////////
procedure LATEX(file,name_list,list,text)

	fprintf file, "\n//// %o\n %o := [\n",text,name_list;
	for i in [1..#list] do
		k := list[i];
		if i ne #list then
			fprintf file, "[\"%o\",\"%o\"],\n", k[1],k[2];
		end if;
		if i eq #list then
			fprintf file, "[\"%o\",\"%o\"]\n", k[1],k[2];
		end if;		
	end for;
	fprintf file, "];\n";
end procedure;

LATEX("output_genus0.txt","Genus0_P1",Genus0_P1,"Genus 0 with rational points:");
LATEX("output_genus0.txt","Genus0_PointlessConic",Genus0_PointlessConic,"Genus 0 without rational points:");


/////////////////////////////////////////////////////////
procedure LATEX0(file,name_list,list,text)

	fprintf file, "\n//// %o\n %o := <\n",text,name_list;
	for i in [1..#list] do
		k := list[i][1];
		T:=list[i][3];
		j:=list[i][2];
		if i ne #list then
			fprintf file, "<[\"%o\",\"%o\"],%o,%o>,\n", k[1],k[2],j,T;
		end if;
		if i eq #list then
			fprintf file, "<[\"%o\",\"%o\"],%o,%o>\n", k[1],k[2],j,T;
		end if;		
	end for;
	fprintf file, ">;\n";
end procedure;




L:=<>;
for k in CurvesByGenus[0] do
k;
C := FiberProducts[k]`curve;
Co,phi1:=Conic(C);
assert HasPoint(Co);
P1:=Curve(ProjectiveSpace(Rationals(),1));
phi2:=Parametrization(Co,P1);
phi3:=Expand(phi2*Inverse(phi1));
phi3polys:=DefiningPolynomials(phi3);
f := Groups[k[1]]`jmap;
h:=Evaluate(f,phi3polys[1]/phi3polys[3]);
T:=Evaluate(t,phi3polys[1]/phi3polys[3]);
TT:=Evaluate(T,[t,1]);
j:=Evaluate(h,[t,1]);
j;
//fprintf "g0_jmaps.txt", "<[\"%o\",\"%o\"],%o,%o>,\n",k[1],k[2],j,T;
L:=Append(L,<k,j,TT>);
end for;

LATEX0("output_genus0.txt","Genus0_jmaps",L,"j-maps of Genus 0 curves:");



